﻿//////////////////////////////////////////////
// RenderContext.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Camera ;
	class Compositor ;
	class GlobalTimer ;
	class RenderContextDescriptor ;
	class System ;
	class Texture ;
	class Viewport ;
}

namespace nkWinUi
{
	class Window ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RenderContext
	{		
		public :
		
			// Destructor
			virtual ~RenderContext () ;

			// Getters
			Texture* getBackBuffer () const ;
			Texture* getDepthBuffer () const ;
			GlobalTimer* getTimer () const ;
			Viewport* getViewport () const ;
			Compositor* getCompositor () const ;
			Camera* getRenderCamera () const ;
			Camera* getCullingCamera () const ;
			Camera* getLodCamera () const ;
			int getWidth () const ;
			int getHeight () const ;
			bool isWindowFocused () const ;
			nkWinUi::Window* getAttachedWin () const ;
			bool getOwnsSurface () const ;

			// Setters
			void setCompositor (Compositor* value) ;
			void setRenderCamera (Camera* value) ;
			void setCullingCamera (Camera* value) ;
			void setLodCamera (Camera* value) ;
			void setOwnsSurface (bool value) ;
			virtual void setGammaCorrected (bool value) = 0 ;

			// Initialization
			virtual void initialize (const RenderContextDescriptor& descriptor) = 0 ;

			// Rendering
			virtual void swap () = 0 ;

			// Chain manipulation
			virtual void refreshBufferSize (unsigned int width = 0, unsigned int height = 0) = 0 ;
			virtual void refreshViewportSize () ;

		protected :

			// Functions
			// Constructor
			RenderContext (System* system) noexcept ;

		protected :
		
			// Attributes
			// System active in
			System* _system ;
			// Size information
			int _width ;
			int _height ;
			// Back buffer used
			Texture* _backBuffer ;
			// Depth target for ease of use
			nkMemory::UniquePtr<Texture> _depthBuffer ;
			// Viewport attached
			nkMemory::UniquePtr<Viewport> _viewport ;
			// Timer for frames
			nkMemory::UniquePtr<GlobalTimer> _timer ;

			// If a compositor is linked
			Compositor* _compositor ;
			// Cameras linked maybe
			Camera* _renderCamera ;
			Camera* _cullingCamera ;
			Camera* _lodCamera ;

			// Attached window
			nkWinUi::Window* _attachedWin ;
			bool _ownsSurface ;
			bool _vsync ;
	} ;
}